#!/bin/bash

echo "Creating user liferay."
useradd liferay --user-group --password liferay1

# Setup my environment
. /vagrant/shell/portal-admin/portal.dev.profile

# Setup the profile for the liferay user
cp /vagrant/shell/portal-admin/portal.dev.profile /home/liferay/.bash_profile
chown liferay:liferay /home/liferay/.bash_profile

if [ ! -d "/u01/app" ]; then
  mkdir -p /u01/app
fi

if [ ! -d "/usr/java" ]; then
  mkdir -p /usr/java
fi

if [ ! -d ${JAVA_HOME} ]; then
	tar zxpf ${SOFTWARE_DIRECTORY}/jdk-8u112-linux-x64.tar.gz -C /usr/java
fi

chown -R liferay:liferay /u01/*

# install random number generator daemon
yum install -y  rng-tools.x86_64
cp /vagrant/shell/portal-admin/rngd.conf /etc/sysconfig/rngd
chkconfig rngd on
service rngd start

# disable iptables on boot so that we can get to our servers
chkconfig iptables off
/etc/init.d/iptables save
/etc/init.d/iptables stop

## RHEL/CentOS 6 64-Bit ##
wget http://download.fedoraproject.org/pub/epel/6/x86_64/epel-release-6-8.noarch.rpm
rpm -ivh epel-release-6-8.noarch.rpm

yum install -y htop

	